/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.ICustomDrop;
import noppes.npcs.api.entity.data.INPCInventory;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.DropController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public class DataInventory
implements IInventory,
INPCInventory {
    public Map<Integer, IItemStack> armor = new TreeMap<Integer, IItemStack>();
    public final Map<Integer, DropSet> drops = new TreeMap<Integer, DropSet>();
    public boolean lootMode = true;
    private int maxExp = 0;
    private int minExp = 0;
    public int dropType = 0;
    EntityNPCInterface npc;
    public Map<Integer, IItemStack> weapons = new TreeMap<Integer, IItemStack>();
    public Map<Integer, IItemStack> awItems = new TreeMap<Integer, IItemStack>();
    public String saveDropsName = "";
    public int limitation = 0;
    public InventoryBasic deadLoot;
    public Map<EntityLivingBase, InventoryBasic> deadLoots;

    public DataInventory(EntityNPCInterface npcIn) {
        this.npc = npcIn;
    }

    @Override
    public ICustomDrop addDropItem(IItemStack item, double chance) {
        if (this.drops.size() >= CustomNpcs.MaxItemInDropsNPC) {
            throw new CustomNPCsException("Bad maximum size: " + this.drops.size() + " (" + CustomNpcs.MaxItemInDropsNPC + " slots maximum)", new Object[0]);
        }
        chance = ValueUtil.correctDouble(chance, 1.0E-4, 100.0);
        DropSet ds = new DropSet(this);
        ds.item = item;
        ds.chance = chance;
        ds.pos = this.drops.size();
        this.drops.put(ds.pos, ds);
        return ds;
    }

    public void func_174888_l() {
        this.armor.clear();
        this.drops.clear();
        this.weapons.clear();
        this.awItems.clear();
        this.minExp = 0;
        this.maxExp = 0;
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<IEntity<?>, List<IItemStack>> createDrops(int lootType, double baseChance) {
        List<Object> allDrops = new ArrayList<DropSet>();
        if (this.dropType != 0 && !this.saveDropsName.isEmpty()) {
            allDrops = DropController.getInstance().getDrops(this.saveDropsName);
        }
        if (this.dropType != 1) {
            allDrops.addAll(this.drops.values());
        }
        ArrayList<IItemStack> anyItems = new ArrayList<IItemStack>();
        HashMap map = new HashMap();
        for (DropSet dropSet : allDrops) {
            IItemStack iStack;
            double c = dropSet.chance * baseChance / 100.0;
            double r = Math.random();
            if (dropSet.item == null || dropSet.item.isEmpty() || lootType != dropSet.lootMode || dropSet.amount[0] == 0 && dropSet.amount[1] == 0 || c < 1.0 && c < r || (iStack = dropSet.createLoot(baseChance)).isEmpty()) continue;
            int qID = dropSet.getQuestID();
            if (qID > 0) {
                for (EntityLivingBase attacking : this.npc.combatHandler.aggressors.keySet()) {
                    IEntity<?> iEntity;
                    Quest quest;
                    PlayerData data;
                    if (!(attacking instanceof EntityPlayer) || (data = PlayerData.get((EntityPlayer)attacking)) == null || !data.questData.activeQuests.containsKey(qID) || (quest = QuestController.instance.quests.get(qID)) == null) continue;
                    boolean needAdd = true;
                    for (QuestObjective objQ : quest.getObjectives((EntityPlayer)attacking)) {
                        if (objQ.getEnumType() != EnumQuestTask.ITEM || !objQ.getItemStack().func_77969_a(iStack.getMCItemStack()) || !objQ.isCompleted()) continue;
                        needAdd = false;
                        break;
                    }
                    if (!needAdd || (iEntity = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)attacking)) == null) continue;
                    if (!map.containsKey(iEntity)) {
                        map.put(iEntity, new ArrayList());
                    }
                    ((List)map.get(iEntity)).add(iStack);
                }
                continue;
            }
            anyItems.add(iStack);
        }
        if (!anyItems.isEmpty()) {
            void var8_9;
            Collections.shuffle(anyItems, new Random());
            LinkedHashMap<EntityLivingBase, Double> aggressors = Util.instance.sortByValue(this.npc.combatHandler.aggressors);
            Object var8_8 = null;
            LinkedHashMap entitys = new LinkedHashMap();
            double totalDamageValue = 0.0;
            for (EntityLivingBase attacking : aggressors.keySet()) {
                IEntity<?> iEntity;
                if (!(attacking instanceof EntityPlayer) && (this.npc.combatHandler.onlyPlayers || lootType == 2) || (iEntity = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)attacking)) == null) continue;
                if (var8_9 == null) {
                    IEntity<?> iEntity2 = iEntity;
                }
                entitys.put(iEntity, aggressors.get(attacking));
                totalDamageValue += aggressors.get(attacking).doubleValue();
            }
            HashMap<Object, Integer> itemsToEntity = new HashMap<Object, Integer>();
            int s = anyItems.size();
            for (IEntity attacking : entitys.keySet()) {
                int amount = (int)Math.round(totalDamageValue / (Double)entitys.get(attacking) * (double)anyItems.size());
                if (amount > s) {
                    amount = 2;
                }
                itemsToEntity.put(attacking, amount);
                if ((s -= amount) != 0) continue;
                break;
            }
            if (var8_9 == null) {
                map.put(this.npc.wrappedNPC, anyItems);
            } else {
                if (s != 0) {
                    itemsToEntity.put(var8_9, (Integer)itemsToEntity.get(var8_9) + s);
                }
                for (IEntity attacking : itemsToEntity.keySet()) {
                    if (anyItems.isEmpty()) break;
                    for (int i = 0; i < (Integer)itemsToEntity.get(attacking) && !anyItems.isEmpty(); ++i) {
                        IItemStack iStack = (IItemStack)anyItems.get(0);
                        if (!map.containsKey(attacking)) {
                            map.put(attacking, new ArrayList());
                        }
                        ((List)map.get(attacking)).add(iStack);
                        anyItems.remove(iStack);
                    }
                }
            }
        }
        return map;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot0, int slot1) {
        int i;
        Map<Integer, IItemStack> map;
        ItemStack var4 = null;
        if (slot0 >= 7) {
            map = this.awItems;
            slot0 -= 7;
            i = 3;
        } else if (slot0 >= 4) {
            map = this.weapons;
            slot0 -= 4;
            i = 1;
        } else {
            map = this.armor;
            i = 2;
        }
        if (map.get(slot0) != null) {
            if (map.get(slot0).getMCItemStack().func_190916_E() <= slot1) {
                var4 = map.get(slot0).getMCItemStack();
                map.put(slot0, null);
            } else {
                var4 = map.get(slot0).getMCItemStack().func_77979_a(slot1);
                if (map.get(slot0).getMCItemStack().func_190916_E() == 0) {
                    map.put(slot0, null);
                }
            }
        }
        if (i == 1) {
            this.weapons = map;
        } else if (i == 2) {
            this.armor = map;
        } else {
            this.awItems = map;
        }
        if (var4 == null) {
            return ItemStack.field_190927_a;
        }
        return var4;
    }

    public void dropStuff(NpcEvent.DiedEvent event, DamageSource damagesource) {
        block21: {
            boolean notDropOnGround;
            this.deadLoot = null;
            this.deadLoots = null;
            ArrayList<EntityItem> list = new ArrayList<EntityItem>();
            if (event.droppedItems != null) {
                for (IItemStack iStack : event.droppedItems) {
                    EntityItem entityItem;
                    if (iStack == null || iStack.isEmpty() || (entityItem = this.getEntityItem(iStack.getMCItemStack().func_77946_l(), event.droppedItems.length > 7)) == null) continue;
                    list.add(entityItem);
                }
            }
            if (!(notDropOnGround = ForgeHooks.onLivingDrops((EntityLivingBase)this.npc, (DamageSource)damagesource, list, (int)0, (boolean)true))) {
                for (EntityItem e : list) {
                    if (e == null) continue;
                    this.npc.field_70170_p.func_72838_d((Entity)e);
                }
            }
            list.clear();
            if (event.lootedItems != null) {
                for (IEntity<?> iEntity : event.lootedItems.keySet()) {
                    for (IItemStack iItemStack : event.lootedItems.get(iEntity)) {
                        EntityItem e;
                        if (iItemStack == null || iItemStack.isEmpty() || (e = this.getEntityItem(iItemStack.getMCItemStack().func_77946_l(), event.lootedItems.get(iEntity).size() > 7)) == null) continue;
                        if (iEntity instanceof IPlayer) {
                            EntityPlayer player = (EntityPlayer)iEntity.getMCEntity();
                            e.func_174867_a(2);
                            e.func_145797_a(player.func_70005_c_());
                            this.npc.field_70170_p.func_72838_d((Entity)e);
                            ItemStack stack = e.func_92059_d();
                            int i = stack.func_190916_E();
                            if (!player.field_71071_by.func_70441_a(stack)) continue;
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                            player.func_71001_a((Entity)e, i);
                            if (stack.func_190916_E() > 0) continue;
                            e.func_70106_y();
                            continue;
                        }
                        e.func_70107_b(iEntity.getPos().getX(), iEntity.getPos().getY() + (double)iEntity.getMCEntity().func_70047_e() / 2.0, iEntity.getPos().getZ());
                        this.npc.field_70170_p.func_72838_d((Entity)e);
                    }
                }
            }
            if (event.inventoryItems != null) {
                if (event.totalDamageOnlyPlayers == 0.0) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (IEntity<?> iEntity : event.inventoryItems.keySet()) {
                        for (IItemStack iStack : event.inventoryItems.get(iEntity)) {
                            stacks.add(iStack.getMCItemStack());
                            if (stacks.size() != 54) continue;
                            break;
                        }
                        if (stacks.size() != 54) continue;
                        break;
                    }
                    int size = (int)(Math.ceil((double)stacks.size() / 9.0) * 9.0);
                    this.deadLoot = new InventoryBasic("NPC Loot", true, Math.max(9, size));
                    int i = 0;
                    for (ItemStack stack : stacks) {
                        this.deadLoot.func_70299_a(i, stack);
                        ++i;
                    }
                }
                for (IEntity<?> iEntity : event.inventoryItems.keySet()) {
                    int size = (int)(Math.ceil((double)event.inventoryItems.get(iEntity).size() / 9.0) * 9.0);
                    InventoryBasic inventoryBasic = new InventoryBasic("NPC Loot", true, Math.max(9, size));
                    int i = 0;
                    for (IItemStack iStack : event.inventoryItems.get(iEntity)) {
                        inventoryBasic.func_70299_a(i, iStack.getMCItemStack());
                        ++i;
                    }
                    if (this.deadLoots == null) {
                        this.deadLoots = new HashMap<EntityLivingBase, InventoryBasic>();
                    }
                    this.deadLoots.put((EntityLivingBase)iEntity.getMCEntity(), inventoryBasic);
                }
            }
            if (event.expDropped <= 0) break block21;
            if (!this.lootMode) {
                int currentValue;
                for (int exp = event.expDropped; exp > 0; exp -= currentValue) {
                    currentValue = EntityXPOrb.func_70527_a((int)exp);
                    this.npc.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.npc.field_70170_p, this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, currentValue));
                }
            } else {
                for (IEntity<?> iEntity : event.damageMap.keySet()) {
                    int currentValue;
                    if (!(iEntity instanceof IPlayer)) continue;
                    Object obj = iEntity.getMCEntity();
                    for (int exp = (int)((double)event.expDropped * event.damageMap.get(iEntity) / event.totalDamageOnlyPlayers); exp > 0; exp -= currentValue) {
                        currentValue = EntityXPOrb.func_70527_a((int)exp);
                        this.npc.field_70170_p.func_72838_d((Entity)new EntityXPOrb(((Entity)obj).field_70170_p, ((Entity)obj).field_70165_t, ((Entity)obj).field_70163_u, ((Entity)obj).field_70161_v, currentValue));
                    }
                }
            }
        }
    }

    @Override
    public IItemStack getArmor(int slot) {
        return this.armor.get(slot);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public ICustomDrop getDrop(int slot) {
        if (slot < 0 || slot >= this.drops.size()) {
            throw new CustomNPCsException("Bad slot number: " + slot + " in " + this.drops.size() + " maximum", new Object[0]);
        }
        return this.drops.get(slot);
    }

    @Override
    public IItemStack getDropItem(int slot) {
        if (slot < 0 || slot >= this.drops.size()) {
            throw new CustomNPCsException("Bad slot number: " + slot + " in " + this.drops.size() + " maximum", new Object[0]);
        }
        DropSet g = this.drops.get(slot);
        return g.getItem();
    }

    @Override
    public ICustomDrop[] getDrops() {
        ICustomDrop[] dss = new ICustomDrop[this.drops.size()];
        int i = 0;
        for (DropSet ds : this.drops.values()) {
            dss[i] = ds;
            ++i;
        }
        return dss;
    }

    public EntityItem getEntityItem(ItemStack itemstack, boolean throwFar) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return null;
        }
        EntityItem entityitem = new EntityItem(this.npc.field_70170_p, this.npc.field_70165_t, this.npc.field_70163_u - (double)0.3f + (double)this.npc.func_70047_e(), this.npc.field_70161_v, itemstack);
        entityitem.func_174867_a(40);
        if (throwFar) {
            float f2 = this.npc.func_70681_au().nextFloat() * 0.5f;
            float f3 = this.npc.func_70681_au().nextFloat() * 3.141593f * 2.0f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f3) * f2;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f3) * f2;
            entityitem.field_70181_x = 0.2f;
        }
        return entityitem;
    }

    @Override
    public int getExpMax() {
        return this.npc.inventory.maxExp;
    }

    @Override
    public int getExpMin() {
        return this.npc.inventory.minExp;
    }

    @Override
    public int getExpRNG() {
        int exp = this.minExp;
        if (this.maxExp - this.minExp > 0) {
            exp += this.npc.field_70170_p.field_73012_v.nextInt(this.maxExp - this.minExp);
        }
        return exp;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public IItemStack getLeftHand() {
        return this.weapons.get(2);
    }

    @Nonnull
    public String func_70005_c_() {
        return "NPC Inventory";
    }

    @Override
    public IItemStack getProjectile() {
        return this.weapons.get(1);
    }

    @Override
    public IItemStack getRightHand() {
        return this.weapons.get(0);
    }

    public int func_70302_i_() {
        return 7 + this.drops.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot < 4) {
            return ItemStackWrapper.MCItem(this.getArmor(slot));
        }
        if (slot < 7) {
            return ItemStackWrapper.MCItem(this.weapons.get(slot - 4));
        }
        if (slot < 9) {
            return ItemStackWrapper.MCItem(this.awItems.get(slot - 7));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean getXPLootMode() {
        return this.lootMode;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack item = this.func_70301_a(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        this.minExp = compound.func_74762_e("MinExp");
        this.maxExp = compound.func_74762_e("MaxExp");
        this.armor = NBTTags.getIItemStackMap(compound.func_150295_c("Armor", 10));
        this.weapons = NBTTags.getIItemStackMap(compound.func_150295_c("Weapons", 10));
        this.awItems = NBTTags.getIItemStackMap(compound.func_150295_c("AWModItems", 10));
        HashMap<Integer, DropSet> drs = new HashMap<Integer, DropSet>();
        if (compound.func_150297_b("DropChance", 9)) {
            Map<Integer, IItemStack> d_old = NBTTags.getIItemStackMap(compound.func_150295_c("NpcInv", 10));
            HashMap<Integer, Integer> dc_old = NBTTags.getIntegerIntegerMap(compound.func_150295_c("DropChance", 10));
            int i = 0;
            for (int slot : d_old.keySet()) {
                if ((Integer)dc_old.get(slot) <= 0) continue;
                DropSet ds = new DropSet(this);
                ds.item = d_old.get(slot);
                ds.chance = ((Integer)dc_old.get(slot)).intValue();
                ds.amount = new int[]{ds.item.getStackSize(), ds.item.getStackSize()};
                ds.pos = i;
                drs.put(i, ds);
                ++i;
            }
        } else {
            int i = 0;
            while (i < compound.func_150295_c("NpcInv", 10).func_74745_c()) {
                DropSet ds = new DropSet(this);
                ds.load(compound.func_150295_c("NpcInv", 10).func_150305_b(i));
                ds.pos = i++;
                drs.put(ds.pos, ds);
            }
        }
        this.drops.clear();
        this.drops.putAll(drs);
        this.lootMode = compound.func_74767_n("LootMode");
        this.saveDropsName = compound.func_74779_i("SaveDropsName");
        this.dropType = compound.func_74762_e("DropType");
        this.limitation = compound.func_74762_e("Limitation");
        if (this.dropType < 0) {
            this.dropType *= -1;
        }
        if (this.dropType > 2) {
            this.dropType %= 3;
        }
    }

    @Override
    public boolean removeDrop(ICustomDrop drop) {
        TreeMap<Integer, DropSet> newDrop = new TreeMap<Integer, DropSet>();
        boolean del = false;
        int j = 0;
        for (int slot : this.drops.keySet()) {
            if (this.drops.get(slot) == drop) {
                del = true;
                continue;
            }
            newDrop.put(j, this.drops.get(slot));
            ((DropSet)newDrop.get((Object)Integer.valueOf((int)j))).pos = j;
            ++j;
        }
        if (del) {
            this.drops.clear();
            this.drops.putAll(newDrop);
        }
        return del;
    }

    @Override
    public boolean removeDrop(int slot) {
        if (this.drops.containsKey(slot)) {
            this.drops.remove(slot);
            TreeMap<Integer, DropSet> newDrop = new TreeMap<Integer, DropSet>();
            int j = 0;
            for (int s : this.drops.keySet()) {
                if (s == slot) continue;
                newDrop.put(j, this.drops.get(s));
                ((DropSet)newDrop.get((Object)Integer.valueOf((int)j))).pos = j;
                ++j;
            }
            this.drops.clear();
            this.drops.putAll(newDrop);
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        int i;
        Map<Integer, IItemStack> map;
        if (slot >= 7) {
            map = this.awItems;
            slot -= 7;
            i = 3;
        } else if (slot >= 4) {
            map = this.weapons;
            slot -= 4;
            i = 1;
        } else {
            map = this.armor;
            i = 2;
        }
        if (map.get(slot) != null) {
            ItemStack var3 = map.get(slot).getMCItemStack();
            map.put(slot, null);
            if (i == 1) {
                this.weapons = map;
            } else if (i == 2) {
                this.armor = map;
            } else {
                this.awItems = map;
            }
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        this.armor.put(slot, item);
        this.npc.updateClient = true;
    }

    @Override
    public void setExp(int min, int max) {
        this.npc.inventory.minExp = min = Math.min(min, max);
        this.npc.inventory.maxExp = max;
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_70299_a(int slot, @Nonnull ItemStack item) {
        int i;
        Map<Integer, IItemStack> var3;
        if (slot >= 7) {
            var3 = this.awItems;
            slot -= 7;
            i = 3;
        } else if (slot >= 4) {
            var3 = this.weapons;
            slot -= 4;
            i = 1;
        } else {
            var3 = this.armor;
            i = 2;
        }
        var3.put(slot, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
        if (i == 1) {
            this.weapons = var3;
        } else if (i == 2) {
            this.armor = var3;
        } else {
            this.awItems = var3;
        }
    }

    @Override
    public void setLeftHand(IItemStack item) {
        this.weapons.put(2, item);
        this.npc.updateClient = true;
    }

    @Override
    public void setProjectile(IItemStack item) {
        this.weapons.put(1, item);
        this.npc.updateAI = true;
    }

    @Override
    public void setRightHand(IItemStack item) {
        this.weapons.put(0, item);
        this.npc.updateClient = true;
    }

    @Override
    public void setXPLootMode(boolean mode) {
        this.lootMode = mode;
    }

    public NBTTagCompound writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74768_a("MinExp", this.minExp);
        compound.func_74768_a("MaxExp", this.maxExp);
        compound.func_74782_a("Armor", (NBTBase)NBTTags.nbtIItemStackMap(this.armor));
        compound.func_74782_a("Weapons", (NBTBase)NBTTags.nbtIItemStackMap(this.weapons));
        compound.func_74782_a("AWModItems", (NBTBase)NBTTags.nbtIItemStackMap(this.awItems));
        NBTTagList dropList = new NBTTagList();
        int s = 0;
        for (int slot : this.drops.keySet()) {
            if (this.drops.get(slot) == null) continue;
            if (this.drops.get((Object)Integer.valueOf((int)slot)).pos != s) {
                this.drops.get((Object)Integer.valueOf((int)slot)).pos = s;
            }
            dropList.func_74742_a((NBTBase)this.drops.get(slot).getNBT());
            ++s;
        }
        compound.func_74782_a("NpcInv", (NBTBase)dropList);
        compound.func_74757_a("LootMode", this.lootMode);
        compound.func_74778_a("SaveDropsName", this.saveDropsName);
        compound.func_74768_a("DropType", this.dropType);
        compound.func_74768_a("Limitation", this.limitation);
        return compound;
    }
}

